############### ###############
## share_NAs
## Project: CBO
## Author: Kamil Kouhen
## Date of creation: 01/05/2022
############### ###############

# Purpose: Creating an excel report of the share of missing values for all the variables in a dataset

share_NAs <- function(df){

  if (!("tidyverse" %in% .packages()) | !("readxl" %in% .packages()) | !("writexl" %in% .packages()) | !("here" %in% .packages())){
    stop("tidyverse, readxl and writexl are needed for this function, please load them before using this function")
    break
  } else{
  dataname <- deparse(substitute(df)) #removing string format

  date <- str_replace(str_replace(str_replace(str_replace(paste0(Sys.time()), "-", ""), ":", ""), "-", ""), ":", "")

  one <- df %>%
    map_dfc(attr, "label") %>% #Extracting labels and variable names
    bind_rows(mutate_all(df, as.character)) %>%
    filter(row_number()==1) %>%
    gather(variable, value) %>%
    rename("label" = value)

  df <- df %>% mutate(across(all_of(df %>% select_if(is.character) %>% colnames), ~ifelse(.=="", NA, as.character(.))))
  #Adding share of NAs
  two <- as_tibble(
    map(df, function(y) (sum(length(which(is.na(y))))/length(y)))) %>%
    gather(variable, value) %>%
    rename("Share_NA" = value)

  #Final dataframe
  Share_of_NAs <- left_join(one, two)

  filename <- paste0("Share of NAs - ", dataname, ".xlsx")
  write_xlsx(Share_of_NAs, here("Output", "For Cleaning", filename))
  }
}
